// Copyright 1992 by Jon Dart.  All Rights Reserved.

#ifndef _MOVE_ORDERING_H
#define _MOVE_ORDERING_H

#include "emove.h"
#include "board.h"

class Move_Ordering
{
    // sorts moves according to plausibility, maintains killer list.

    public:	
	
    static void sort_moves( Move moves[], int scores[], int n);
    // sort "n" moves in order of scores.
	    
    static void order_moves( Board &board, Move moves[], const int num_moves,
			     const int ply, const Move &best_move );	    
    // order moves returned by the move generator in order of
    // guesstimated "goodness".	    

    static int score( Board &board, const Move &move);
    // return a score for an individual move.  The higher the score,
    // the earlier in the search order it should be tried.
	    
    static void set_killer( const Board &board,
      ExtendedMove &move, const unsigned ply );
    // store "move" as a killer move for "ply"
	
    static void clear_killer();
    // clear out the killer move array.
		
};

#endif
